<?php
/**
 * save_photo.php (FINAL)
 * - Validasi cookie login (COOKIES_MEMBER + COOKIES_COOKIES)
 * - Pastikan QR adalah milik user yang login (employees_code)
 * - Validasi lokasi terhadap building.radius (meter)
 * - Simpan foto ke /uploads dan simpan/update record ke tabel presence
 *
 * Me-rely pada: sw-library/sw-config.php (koneksi), sw-function.php (opsional epm_decode)
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// === 1) Load koneksi & fungsi (pastikan path benar) ===
include_once __DIR__ . '/sw-library/sw-config.php';
@include_once __DIR__ . '/sw-library/sw-function.php'; // optional (epm_decode, anti_injection, etc.)

if (!isset($connection) || !($connection instanceof mysqli)) {
    exit('❌ Koneksi database tidak ditemukan. Periksa sw-config.php');
}

// === 2) Pastikan cookies ada ===
if (empty($_COOKIE['COOKIES_MEMBER']) || empty($_COOKIE['COOKIES_COOKIES'])) {
    exit('❌ Sesi login tidak ditemukan. Silakan login ulang.');
}

$cookie_member_raw = $_COOKIE['COOKIES_MEMBER'];
$cookie_token = mysqli_real_escape_string($connection, $_COOKIE['COOKIES_COOKIES']);

// === 3) Decode COOKIES_MEMBER => employee id
$logged_id = null;
if (function_exists('epm_decode')) {
    // jika sw-function menyediakan epm_decode
    $try = @epm_decode($cookie_member_raw);
    if (is_numeric($try)) $logged_id = intval($try);
}
// fallback: jika cookie berisi angka/encoded id sederhana, ambil angka
if ($logged_id === null) {
    // ambil semua digit dari cookie
    preg_match('/(\d+)/', $cookie_member_raw, $m);
    if (!empty($m[1])) $logged_id = intval($m[1]);
}

// jika tetap tidak dapat, keluar
if (empty($logged_id)) {
    exit('❌ Sesi login tidak valid. Silakan login ulang.');
}

// === 4) Ambil data user dari DB dan cocokkan created_cookies (token) ===
$logged_id_esc = intval($logged_id);
$sqlUser = "SELECT id, employees_code, employees_name, building_id, created_cookies
            FROM employees
            WHERE id = $logged_id_esc
            LIMIT 1";
$qUser = mysqli_query($connection, $sqlUser);
if (!$qUser || mysqli_num_rows($qUser) === 0) {
    exit('❌ Pengguna tidak ditemukan. Silakan login ulang.');
}
$user = mysqli_fetch_assoc($qUser);

// cocokan token cookie dengan created_cookies DB
if ($user['created_cookies'] !== $cookie_token) {
    exit('❌ Sesi login tidak valid atau sudah kedaluwarsa. Silakan login ulang.');
}

// set beberapa variabel user
$logged_code = trim($user['employees_code']);
$logged_name = $user['employees_name'];
$building_id = intval($user['building_id']);

// === 5) Folder uploads ===
$uploadDir = __DIR__ . '/uploads/';
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        exit('❌ Gagal membuat folder uploads. Cek permission.');
    }
}

// === 6) Pastikan POST method ===
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    exit('❌ Metode tidak diizinkan. (Gunakan POST)');
}

// === 7) Ambil data dari request ===
$imageData = $_POST['image'] ?? '';
$qrText = trim($_POST['qr'] ?? '');
$coord = trim($_POST['coord'] ?? ''); // format "lat,lng"

if ($imageData === '' || $qrText === '') {
    exit('❌ Data foto atau QR tidak diterima.');
}

// === 8) Pastikan QR adalah milik user yang login ===
if (strcasecmp($qrText, $logged_code) !== 0) {
    exit('❌ Gagal! QR Code ini bukan milik Anda. Anda hanya dapat absen menggunakan QR pribadi.');
}

// === 9) Ambil data building (lat,lng + radius) berdasarkan building_id user ===
$sqlB = "SELECT latitude_longtitude, radius FROM building WHERE building_id = " . intval($building_id) . " LIMIT 1";
$qB = mysqli_query($connection, $sqlB);
if (!$qB || mysqli_num_rows($qB) === 0) {
    exit('❌ Data lokasi kantor tidak ditemukan. Hubungi admin.');
}
$rowB = mysqli_fetch_assoc($qB);
$officeLoc = trim($rowB['latitude_longtitude']); // ex: "-6.2,106.8"
$officeRadius = floatval($rowB['radius'] ?? 0);
if ($officeLoc === '' || $officeRadius <= 0) {
    exit('❌ Data lokasi/radius kantor tidak valid. Hubungi admin.');
}

// === 10) Validasi koordinat user (harus dikirim oleh front-end) ===
if ($coord === '' || strpos($coord, ',') === false) {
    exit('❌ Koordinat pengguna tidak diterima atau belum diizinkan browser.');
}
list($userLat, $userLng) = array_map('floatval', explode(',', $coord));
list($officeLat, $officeLng) = array_map('floatval', explode(',', $officeLoc));

// === 11) Hitung jarak (Haversine) ===
function haversine_distance_m($lat1, $lon1, $lat2, $lon2) {
    $R = 6371000; // meter
    $dLat = deg2rad($lat2 - $lat1);
    $dLon = deg2rad($lon2 - $lon1);
    $a = sin($dLat/2) * sin($dLat/2) + cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * sin($dLon/2) * sin($dLon/2);
    $c = 2 * atan2(sqrt($a), sqrt(1-$a));
    return $R * $c;
}
$distance = haversine_distance_m($userLat, $userLng, $officeLat, $officeLng);

// jika di luar radius -> tolak absen
if ($distance > $officeRadius) {
    exit("❌ Gagal absen. Anda berada di luar radius kantor.<br>📏 Jarak Anda: <b>" . round($distance,1) . " m</b> (batas $officeRadius m)");
}

// === 12) Decode & simpan gambar ===
if (strpos($imageData, 'base64,') === false) {
    exit('❌ Format data gambar tidak valid.');
}
$base64 = preg_replace('#^data:image/\w+;base64,#i', '', $imageData);
$base64 = str_replace(' ', '+', $base64);
$binary = base64_decode($base64);
if ($binary === false) {
    exit('❌ Gagal decode data gambar.');
}

$safeQr = preg_replace('/[^A-Za-z0-9_\-]/', '_', $qrText);
$fileName = 'presence_' . $safeQr . '_' . time() . '.png';
$filePath = $uploadDir . $fileName;

if (file_put_contents($filePath, $binary) === false) {
    exit('❌ Gagal menyimpan foto. Pastikan folder uploads dapat ditulis.');
}

// === 13) Timestamp & koordinat safe ===
$tanggal = date('Y-m-d');
$jam = date('H:i:s');
$coordSafe = $connection->real_escape_string($coord);

// === 14) Cek apakah sudah absen hari ini untuk user ini ===
$sqlCheck = "SELECT * FROM presence WHERE employees_id='" . intval($logged_id) . "' AND presence_date='$tanggal' ORDER BY presence_id DESC LIMIT 1";
$qCheck = mysqli_query($connection, $sqlCheck);
if ($qCheck === false) {
    @unlink($filePath);
    exit('❌ Error DB saat cek presence: ' . mysqli_error($connection));
}
$rowCheck = mysqli_fetch_assoc($qCheck);

// === 15) Insert / Update logic ===
if (!$rowCheck) {
    // belum ada -> Masuk
    $sql = "INSERT INTO presence 
        (employees_id, presence_date, time_in, time_out, present_id, latitude_longtitude_in, latitude_longtitude_out, information, photo_qr, photo_in, photo_out)
        VALUES
        ('" . intval($logged_id) . "', '$tanggal', '$jam', '00:00:00', 1, '$coordSafe', '', '', '$fileName', '$fileName', '')";
    $type = 'Masuk';
} else {
    // sudah ada -> cek time_out
    $time_out = $rowCheck['time_out'];
    $presence_id = intval($rowCheck['presence_id']);
    if ($time_out === null || trim($time_out) === '' || $time_out === '00:00:00') {
        // update Pulang
        $sql = "UPDATE presence 
                SET time_out='$jam', photo_out='$fileName', latitude_longtitude_out='$coordSafe', present_id=2 
                WHERE presence_id='$presence_id' LIMIT 1";
        $type = 'Pulang';
    } else {
        // Masuk baru
        $sql = "INSERT INTO presence 
            (employees_id, presence_date, time_in, time_out, present_id, latitude_longtitude_in, latitude_longtitude_out, information, photo_qr, photo_in, photo_out)
            VALUES
            ('" . intval($logged_id) . "', '$tanggal', '$jam', '00:00:00', 1, '$coordSafe', '', '', '$fileName', '$fileName', '')";
        $type = 'Masuk (baru)';
    }
}

$res = mysqli_query($connection, $sql);
if ($res) {
    echo "✅ Absen $type berhasil untuk <b>" . htmlspecialchars($logged_name) . "</b> (Kode: " . htmlspecialchars($qrText) . ")<br>
          📍 Lokasi: $coordSafe<br>
          📏 Jarak ke kantor: <b>" . round($distance,1) . " m</b><br>
          📸 Foto tersimpan: <b>uploads/$fileName</b>";
    exit;
} else {
    @unlink($filePath);
    exit('❌ Gagal menyimpan ke tabel presence: ' . mysqli_error($connection));
}
?>
