<?php 
if ($mod ==''){
    header('location:../404');
    echo'kosong';
}else{
    include_once 'sw-mod/sw-header.php';

if(!isset($_COOKIE['COOKIES_MEMBER']) && !isset($_COOKIE['COOKIES_COOKIES'])){
    setcookie('COOKIES_MEMBER', '', 0, '/');
    setcookie('COOKIES_COOKIES', '', 0, '/');
    setcookie("COOKIES_MEMBER", "", time()-$expired_cookie);
    setcookie("COOKIES_COOKIES", "", time()-$expired_cookie);
    session_destroy();
    header("location:./"); 
}else{
$query_building  ="SELECT latitude_longtitude,radius FROM building WHERE building_id='$row_user[building_id]'";
$result_building = $connection->query($query_building);
$row_building = $result_building->fetch_assoc();

echo '
<!-- App Capsule -->
<div id="appCapsule">
    <div class="section wallet-card-section pt-1">
        <div class="wallet-card">
            <div class="balance">
                <div class="left">
                    <span class="title"> Selamat '.$salam.'</span>
                    <h4>'.ucfirst($row_user['employees_name']).'</h4>
                </div>
                <div class="right">
                    <span class="title">'.tgl_ind($date).'</span>
                    <h4><span class="clock"></span></h4>
                </div>
            </div>
            <div class="text-center">
                <h4 class="text-center">Arahkan Kode QR Ke Kamera!</h4>
                <div id="reader" style="width: 320px; margin:auto;"></div>
                <audio id="my_audio" class="d-none">
                    <source src="./sw-mod/sw-assets/js/plugins/html5-qrcode/audio/beep.mp3" type="audio/mpeg">
                </audio>
                <p class="text-center">Arahkan QR Code Ke Kamera!</p>
            </div>
        </div>
    </div>
</div>';
}
include_once 'sw-mod/sw-footer.php';
} 
?>

<!-- ================================================= -->
<!-- Script QR, SweetAlert, Validasi Radius + Ambil Foto -->
<!-- ================================================= -->
<script src="https://unpkg.com/html5-qrcode"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener("DOMContentLoaded", function() {
  const html5QrCode = new Html5Qrcode("reader");

  // === Ambil data lokasi kantor & radius dari PHP ===
  const officeLocation = "<?php echo $row_building['latitude_longtitude']; ?>"; // contoh: -6.2155,106.8451
  const officeRadius = parseFloat("<?php echo $row_building['radius']; ?>"); // dalam meter

  // === Fungsi hitung jarak (Haversine formula) ===
  function calculateDistance(lat1, lon1, lat2, lon2) {
    const R = 6371000; // meter
    const dLat = (lat2 - lat1) * Math.PI / 180;
    const dLon = (lon2 - lon1) * Math.PI / 180;
    const a = Math.sin(dLat/2) * Math.sin(dLat/2) +
              Math.cos(lat1*Math.PI/180) * Math.cos(lat2*Math.PI/180) *
              Math.sin(dLon/2) * Math.sin(dLon/2);
    const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1-a));
    return R * c;
  }

  // === Mulai scanner QR ===
  function startScanner() {
    html5QrCode.start(
      { facingMode: "user" },
      { fps: 10, qrbox: 250 },
      qrCodeMessage => {
        try { document.getElementById("my_audio").play(); } catch(e){}
        html5QrCode.stop();

        // Setelah QR kebaca, validasi lokasi
        validateLocation(qrCodeMessage);
      },
      err => {}
    ).catch(err => {
      Swal.fire({ icon: 'error', title: 'Kamera Error', text: err.toString() });
    });
  }

  // === Validasi lokasi sebelum ambil foto ===
  function validateLocation(qrText) {
    Swal.fire({
      title: 'Mengecek Lokasi...',
      text: 'Mohon tunggu, sedang mengambil koordinat Anda...',
      allowOutsideClick: false,
      didOpen: () => Swal.showLoading()
    });

    if (!navigator.geolocation) {
      Swal.close();
      Swal.fire({ icon: 'error', title: 'Perangkat tidak mendukung GPS' });
      return;
    }

    navigator.geolocation.getCurrentPosition(
      function(pos) {
        const lat = pos.coords.latitude;
        const lng = pos.coords.longitude;
        const [officeLat, officeLng] = officeLocation.split(',').map(parseFloat);
        const distance = calculateDistance(lat, lng, officeLat, officeLng);

        Swal.close();

        if (distance <= officeRadius) {
          Swal.fire({
            icon: 'success',
            title: 'Dalam Radius ✅',
            html: `Jarak Anda: <b>${distance.toFixed(1)} m</b><br>Radius Kantor: <b>${officeRadius} m</b>`,
            confirmButtonText: 'Ambil Foto'
          }).then(() => ambilFoto(qrText, lat + ',' + lng));
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Absen Ditolak 🚫',
            html: `Anda di luar radius kantor!<br>Jarak Anda: <b>${distance.toFixed(1)} m</b><br>Batas: <b>${officeRadius} m</b>`,
            confirmButtonText: 'Kembali'
          }).then(() => startScanner());
        }
      },
      function(err) {
        Swal.close();
        Swal.fire({ icon: 'error', title: 'Gagal ambil lokasi', text: err.message });
        startScanner();
      },
      { enableHighAccuracy: true, timeout: 10000, maximumAge: 0 }
    );
  }

  // === Ambil Foto ===
  async function ambilFoto(qrText, coord) {
    try {
      const stream = await navigator.mediaDevices.getUserMedia({ video: { facingMode: "user" } });
      const video = document.createElement('video');
      video.autoplay = true;
      video.playsInline = true;
      video.srcObject = stream;

      Swal.fire({
        title: 'Ambil Foto',
        html: '<video id="videoPreview" width="100%" autoplay playsinline></video><br><button id="btnCapture" class="swal2-confirm swal2-styled">📸 Ambil Foto</button>',
        showConfirmButton: false,
        didOpen: () => {
          const videoEl = document.getElementById('videoPreview');
          videoEl.srcObject = stream;
          document.getElementById('btnCapture').addEventListener('click', () => {
            const canvas = document.createElement('canvas');
            canvas.width = videoEl.videoWidth;
            canvas.height = videoEl.videoHeight;
            canvas.getContext('2d').drawImage(videoEl, 0, 0, canvas.width, canvas.height);
            const imageData = canvas.toDataURL('image/png');
            stream.getTracks().forEach(t => t.stop());
            kirimFoto(imageData, qrText, coord);
          });
        }
      });

    } catch (err) {
      Swal.fire({ icon: 'error', title: 'Kamera gagal dibuka', text: String(err) });
      startScanner();
    }
  }

  // === Kirim Foto & Lokasi ===
  function kirimFoto(imageData, qrText, coord) {
    Swal.fire({
      title: 'Mengirim Data...',
      text: 'Menyimpan foto dan lokasi absen...',
      allowOutsideClick: false,
      didOpen: () => Swal.showLoading()
    });

    const body = new URLSearchParams();
    body.append('image', imageData);
    body.append('qr', qrText);
    body.append('coord', coord);

    fetch('/Ganda_Presensi/save_photo.php', {
      method: 'POST',
      body: body
    })
    .then(res => res.text())
    .then(response => {
      Swal.close();
      Swal.fire({
        icon: 'success',
        title: 'Absen Berhasil',
        html: response,
        timer: 3000,
        showConfirmButton: false
      }).then(() => location.reload());
    })
    .catch(err => {
      Swal.close();
      Swal.fire({ icon: 'error', title: 'Gagal kirim foto', text: String(err) });
      startScanner();
    });
  }

  startScanner();
});
</script>
