<?php 
if ($mod == ''){
    header('location:../404');
    exit();
} else {
    include_once 'sw-mod/sw-header.php';

    if(!isset($_COOKIE['COOKIES_MEMBER']) && !isset($_COOKIE['COOKIES_COOKIES'])){
        setcookie('COOKIES_MEMBER', '', 0, '/');
        setcookie('COOKIES_COOKIES', '', 0, '/');
        setcookie("COOKIES_MEMBER", "", time()-$expired_cookie);
        setcookie("COOKIES_COOKIES", "", time()-$expired_cookie);
        session_destroy();
        header("location:./"); 
        exit();
    } else {

        // jika form disubmit
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $employees_id = intval($_POST['employees_id']);
            $latitude     = $connection->real_escape_string($_POST['latitude']);
            $longitude    = $connection->real_escape_string($_POST['longitude']);
            $timestamp    = $_POST['timestamp'];
            $photoData    = $_POST['photo'];

            // ambil tanggal & jam
            $presence_date = date("Y-m-d");
            $time_now      = date("H:i:s");

            // generate nama file unik
            $photoFile = "jpgpresence/".time()."_".$employees_id.".jpg";

            // simpan foto dari base64
            if (!empty($photoData)) {
                $photoData = str_replace('data:image/jpeg;base64,', '', $photoData);
                $photoData = str_replace(' ', '+', $photoData);
                $photoDecoded = base64_decode($photoData);
                file_put_contents($photoFile, $photoDecoded);
            }

            // gabungkan lat-long
            $latlong = $latitude.",".$longitude;

            // cek apakah user sudah absen hari ini
            $cek = $connection->query("SELECT * FROM presence WHERE employees_id='$employees_id' AND presence_date='$presence_date' LIMIT 1");

            if ($cek->num_rows > 0) {
                // update time_out & latlong_out
                $connection->query("UPDATE presence 
                    SET time_out='$time_now', latitude_longtitude_out='$latlong' 
                    WHERE employees_id='$employees_id' AND presence_date='$presence_date'");
            } else {
                // insert baru (absen masuk)
                $connection->query("INSERT INTO presence 
                    (employees_id, presence_date, time_in, time_out, present_id, latitude_longtitude_in, latitude_longtitude_out, information, photo_in)
                    VALUES 
                    ('$employees_id','$presence_date','$time_now','00:00:00','1','$latlong','','$photoFile','Hadir')");
            }

            echo "<script>alert('Absensi berhasil disimpan!');window.location='index.php';</script>";
        }

        // ambil radius kantor
        $query_building  ="SELECT latitude_longtitude,radius FROM building WHERE building_id='$row_user[building_id]'";
        $result_building = $connection->query($query_building);
        $row_building = $result_building->fetch_assoc();
?>
<!-- App Capsule -->
<div id="appCapsule">
    <div class="section wallet-card-section pt-1">
        <div class="wallet-card">
            <div class="balance">
                <div class="left">
                    <span class="title">Selamat <?= $salam; ?></span>
                    <h4><?= ucfirst($row_user['employees_name']); ?></h4>
                </div>
                <div class="right">
                    <span class="title"><?= tgl_ind($date); ?></span>
                    <h4><span class="clock"></span></h4>
                </div>
            </div>

            <div class="text-center">
                <p class="d-none">Lat-Long: <span class="latitude" id="latitude"></span></p>
            </div>

            <h4 class="text-center">Ambil Selfie untuk Absensi</h4>
            <div class="wallet-footer text-center">
                <div class="webcame text-center">
                    <video id="camera" width="100%" autoplay playsinline></video>
                    <canvas id="snapshot" class="d-none"></canvas>
                    <form id="formAbsensi" method="POST">
                        <input type="hidden" name="employees_id" value="<?= $row_user['employees_id']; ?>">
                        <input type="hidden" name="photo" id="photo">
                        <input type="hidden" name="latitude" id="latitudeInput">
                        <input type="hidden" name="longitude" id="longitudeInput">
                        <input type="hidden" name="timestamp" id="timestamp">
                        <button type="submit" class="btn btn-primary mt-2">Simpan Absensi</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// akses kamera
const video = document.getElementById("camera");
const canvas = document.getElementById("snapshot");
const photoInput = document.getElementById("photo");
const latitudeInput = document.getElementById("latitudeInput");
const longitudeInput = document.getElementById("longitudeInput");
const timestampInput = document.getElementById("timestamp");

navigator.mediaDevices.getUserMedia({ video: true })
.then(stream => { video.srcObject = stream; })
.catch(err => { alert("Kamera tidak bisa diakses: " + err); });

// ambil lokasi GPS
if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(function(position) {
        latitudeInput.value = position.coords.latitude;
        longitudeInput.value = position.coords.longitude;
    }, function(error){
        alert("Lokasi tidak bisa diambil: " + error.message);
    });
}

// auto capture saat submit
document.getElementById("formAbsensi").addEventListener("submit", function(e){
    e.preventDefault();

    const context = canvas.getContext("2d");
    canvas.width = video.videoWidth;
    canvas.height = video.videoHeight;
    context.drawImage(video, 0, 0, canvas.width, canvas.height);

    // convert foto ke base64
    const dataUrl = canvas.toDataURL("image/jpeg");
    photoInput.value = dataUrl;

    // timestamp sekarang
    timestampInput.value = new Date().toISOString();

    this.submit();
});
</script>
<?php
    }
    include_once 'sw-mod/sw-footer.php';
}
?>
