<?php
header('Content-Type: application/json');
require_once '../../../library/sw-config.php';

if (isset($_POST['image']) && isset($_POST['qr_data'])) {
    $qrData = $_POST['qr_data'];
    $img = $_POST['image'];

    // Decode Base64 image
    $img = str_replace('data:image/jpeg;base64,', '', $img);
    $img = str_replace(' ', '+', $img);
    $data = base64_decode($img);

    // Simpan ke folder img/
    $fileName = 'qr_' . time() . '.jpg';
    $filePath = __DIR__ . '/../../sw-assets/img/' . $fileName;

    if (file_put_contents($filePath, $data)) {
        // Kalau mau simpan ke database juga, tambahkan:
        // $connection->query("INSERT INTO qr_logs (qr_data, file_name, created_at) VALUES ('$qrData', '$fileName', NOW())");

        echo json_encode([
            "status" => "success",
            "message" => "Gambar QR berhasil disimpan!",
            "file" => $fileName
        ]);
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "Gagal menyimpan gambar."
        ]);
    }
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Data gambar atau QR tidak ditemukan."
    ]);
}
?>
